function [A,B] = MarchingTria(XY,TRI,V,isovalue,isocap)
narginchk(4,5)
if nargin==4, isocap = 0; end

if size(TRI,2)~=3
    error('Triangle connectivity must have size [N x 3].')
end
if size(XY,2)~=2
    error('Nodal coordinates must have size [M x 2].')
end
if numel(V)~=size(XY,1)
    error('The number of values and coordinates must match.')
end
if ~isscalar(isovalue)
    error('The isovalue must be a scalar.')
end

if (isocap < 0)
    flag = (V < isovalue);
else
    flag = (V > isovalue);
end

% Calculate the isocaps if requested
if (isocap ~= 0)
    BOUND = GetBoundary(TRI);
    BoundIndex = 1 + flag(BOUND(:,1)) * 1 + flag(BOUND(:,2)) * 2;
    SegmentsPerBoundIndex = [0 1 1 1];
    Nbound_segments = sum(SegmentsPerBoundIndex(BoundIndex));
    Acap = nan(Nbound_segments,2);
    Bcap = nan(Nbound_segments,2);
    n = 0;
    for i=1:length(BoundIndex)
        switch BoundIndex(i)
        % case 1 is all-outside
            case 2
                n = n + 1;
                Acap(n,:) = VertexInterp(isovalue,XY(BOUND(i,1),:),XY(BOUND(i,2),:),V(BOUND(i,1)),V(BOUND(i,2)));
                Bcap(n,:) = XY(BOUND(i,1),:);
            case 3
                n = n + 1;
                Acap(n,:) = VertexInterp(isovalue,XY(BOUND(i,1),:),XY(BOUND(i,2),:),V(BOUND(i,1)),V(BOUND(i,2)));
                Bcap(n,:) = XY(BOUND(i,2),:);
            case 4
                n = n + 1;
                Acap(n,:) = XY(BOUND(i,1),:);
                Bcap(n,:) = XY(BOUND(i,2),:);
        end
    end
%     Acap = XY(BOUND(:,1),:);
%     Bcap = XY(BOUND(:,2),:);
else
    Acap = [];
    Bcap = [];
end

% Get going with the marching triangles in the interior of the domain
TriIndex = 1 + flag(TRI(:,1)) * 1 + flag(TRI(:,2)) * 2 + flag(TRI(:,3)) * 4;
SegmentsPerTriangleIndex = [0 1 1 1 1 1 1 0]';
Nsegments = sum(SegmentsPerTriangleIndex(TriIndex));

A = nan(Nsegments,2);
B = nan(Nsegments,2);
n = 0;
for i=1:length(TriIndex)
    switch TriIndex(i)
        % case {1,8} is all-inside or all-outside
        case {2,7}
            n = n + 1;
            A(n,:) = VertexInterp(isovalue,XY(TRI(i,1),:),XY(TRI(i,2),:),V(TRI(i,1)),V(TRI(i,2)));
            B(n,:) = VertexInterp(isovalue,XY(TRI(i,1),:),XY(TRI(i,3),:),V(TRI(i,1)),V(TRI(i,3)));
        case {3,6}
            n = n + 1;
            A(n,:) = VertexInterp(isovalue,XY(TRI(i,2),:),XY(TRI(i,1),:),V(TRI(i,2)),V(TRI(i,1)));
            B(n,:) = VertexInterp(isovalue,XY(TRI(i,2),:),XY(TRI(i,3),:),V(TRI(i,2)),V(TRI(i,3)));
        case {4,5}
            n = n + 1;
            A(n,:) = VertexInterp(isovalue,XY(TRI(i,3),:),XY(TRI(i,1),:),V(TRI(i,3)),V(TRI(i,1)));
            B(n,:) = VertexInterp(isovalue,XY(TRI(i,3),:),XY(TRI(i,2),:),V(TRI(i,3)),V(TRI(i,2)));
    end
end
A = [A; Acap];
B = [B; Bcap];
return

function [BOUND] = GetBoundary(TRI)
EDGE = [TRI(:,1) TRI(:,2);
        TRI(:,2) TRI(:,3);
        TRI(:,3) TRI(:,1)];
EDGE = sort(EDGE,2);
[~,ia,ic] = unique(EDGE,'rows');
count = accumarray(ic,1,[length(ia) 1]);
ind = find(count==1);
BOUND = EDGE(ia(ind),:);
return

function P = VertexInterp(cutoff,P1,P2,V1,V2)
[P,ind] = sortrows([P1; P2]);
if isequal(ind,[1; 2])
    V = [V1; V2];
else
    V = [V2; V1];
end

if (abs(V(2)-V(1)) > 1e-12)
  P = P(1,:) + diff(P) * (cutoff - V(1)) / diff(V);
else
  P = P(1,:);
end
return